#
# OCRatio.R    04/07/2020    Ralf Tautenhahn
# 
# Creates two new columns: O/C ratio and H/C ratio
#
# v1.1
# 


# Read arguments from CD.
args <- commandArgs()

# At least for now, the 6th argument is the name of the JSON file
inputFile <- args[6]

# Open JSON file, find exported files, read into tables
library(rjson)
CD_json_in <- fromJSON(file=inputFile)

datafile1 <- CD_json_in$Tables[[1]]$DataFile
CD.input.Cmp <- read.table(datafile1, header=TRUE, check.names = FALSE, stringsAsFactors = FALSE)

# create result vectors 
oc <- double(nrow(CD.input.Cmp))
hc <- double(nrow(CD.input.Cmp))

require(stringr)

getNumberOfElementsFromFormula <- function(formula, element) {
  if (str_detect(formula,element)) {
    n <- as.integer(str_remove(str_extract(formula, paste(element,"[0-9]+", sep="")),element))
    if (is.na(n))
      return(1)
    else
      return(n)
  }
  return(0)
}

## loop through all Compounds
for (ci in 1:nrow(CD.input.Cmp)) {
  
  fi <- CD.input.Cmp[ci,"Formula"]
  
  if (fi != "") {
    nC <- getNumberOfElementsFromFormula(fi, "C")
    nO <- getNumberOfElementsFromFormula(fi, "O")
    nH <- getNumberOfElementsFromFormula(fi, "H")
      
    oc[ci] <- nO/nC
    hc[ci] <- nH/nC
  }
 
}


# add result column to table
data.output <- cbind(CD.input.Cmp, "O/C" = oc, "H/C" = hc)

# Add new column to JSON structure.
newcolumn <- list()
newcolumn[[1]] = "O/C"     ## ColumnName
newcolumn[[2]] = ""     ## IsID
newcolumn[[3]] = "Float"      ## DataType
newcolumn[[4]] <- list(FormatString="F2")

names(newcolumn) <- c("ColumnName", "ID", "DataType", "Options")

newcolumn2 <-list()
newcolumn2[[1]] = "H/C"   ## columnName
newcolumn2[[2]] = ""     ## IsID
newcolumn2[[3]] = "Float"      ## DataType
newcolumn2[[4]] <- list(FormatString="F2")    ## Options

names(newcolumn2) <- c("ColumnName", "ID", "DataType", "Options")

CD_json_in$Tables[[1]]$ColumnDescriptions[[length(CD_json_in$Tables[[1]]$ColumnDescriptions) + 1]] <- newcolumn
CD_json_in$Tables[[1]]$ColumnDescriptions[[length(CD_json_in$Tables[[1]]$ColumnDescriptions) + 1]] <- newcolumn2

# Write modified table to temporary folder.

resultout <- gsub(".txt", ".out.txt", datafile1)
write.table(data.output, file = resultout, sep='\t', row.names = FALSE)

# Write out node_response.json file - use same file as node_args.json but change the pathway input file to the new one

CD_json_in$Tables[[1]]$DataFile = resultout
jsonOutFile <- CD_json_in$ExpectedResponsePath

responseJSON <- toJSON(CD_json_in, indent=1, method="C")

# responseJSON has incorrect format for the empty Options lists.  Will use a regular expression to find and replace the [\n\n\] with the {}

responseJSON2 <- gsub("\\[\n\n[[:blank:]]+\\]", "{ }", responseJSON)

jsonfileconn <- file(jsonOutFile)

writeLines(responseJSON2, jsonfileconn)

close (jsonfileconn)



