#
# SimpleTest.R    08/04/2022    Ralf Tautenhahn
# A very basic example for a "Scripting node" in Compound Discoverer, all it does is add a value (1.007276) to the Molecular Weight to create an "M+H" column 
# Version 2.0   (CD3.3)
#

Mp = 1.007276

# Read arguments from CD.
args <- commandArgs()

# the 6th argument is the name of the JSON file
inputFile <- args[6]

# Open JSON file, find exported file, read into table
library(rjson)
CD_json_in <- fromJSON(file=inputFile)
datafile <- CD_json_in$Tables[[1]]$DataFile
CD.input <- read.table(datafile, header=TRUE, check.names = FALSE)

# for debugging purposes you could save all the data at this point
# save.image(file="C:\\Rscripts\\CD node Rimage.dat")
# and load it into an interactive Rsession when you develop/debug your node
## load("C:\\Rscripts\\CD node Rimage.dat")

# Calculate Result

#data.output <- cbind(CD.input, MH = CD.input[,"Molecular Weight"] + Mp)    # that was column name in CD3.1
data.output <- cbind(CD.input, MH = CD.input[,"Calc MW"] + Mp)              # new column name in CD3.3

# Add new column to JSON structure.

newcolumn <- list()
newcolumn[[1]] = "MH"       ## ColumnName
newcolumn[[2]] = FALSE      ## IsID
newcolumn[[3]] = "Float"    ## DataType
newcolumn[[4]] <- list()    ## Options

names(newcolumn) <- c("ColumnName", "IsID", "DataType", "Options") 
 
CD_json_in$Tables[[1]]$ColumnDescriptions[[length(CD_json_in$Tables[[1]]$ColumnDescriptions) + 1]] <- newcolumn
 
# Write modified table to temporary folder.

resultout <- gsub(".txt", ".out.txt", datafile)
write.table(data.output, file = resultout, sep='\t', row.names = FALSE)


# Create node_response.json file - use same file as node_args.json but change the input file to the new one

CD_json_in$Tables[[1]]$DataFile = resultout
jsonOutFile <- CD_json_in$ExpectedResponsePath

responseJSON <- toJSON(CD_json_in, indent=1, method="C")

# responseJSON has incorrect format for the empty Options lists.  Will use a regular expression to find and replace the [\n\n\] with the {}
responseJSON2 <- gsub("\\[\n\n[[:blank:]]+\\]", "{ }", responseJSON)

# Write out node_response.json file
jsonfileconn <- file(jsonOutFile)
writeLines(responseJSON2, jsonfileconn)
close (jsonfileconn)

