#
# ExportCpdsAllIons.R    05/13/2025    Ralf Tautenhahn       ralf.tautenhahn@thermofisher.com
# 
#
#  v1.2
# 
#  Export the Compounds table with all ions for each compound
#  
#  Requested Tables and Columns   
#  Compounds: Name, Formula, Calc. MW, RT [min], Area (Max.); Features: Ion, m/z, Area (Max.), Intensity (Max.) 
#
#  Changelog
#  v1.0  01/27/2023	 First release
#  v1.1  05/05/2025  Compatibility with CD 3.4, order table by Area Max. desc., order ions by Intensity (Max) desc.
#  v1.2  05/13/2025  added option to export Area (Max.)  [default] or Intensity (Max.) for each feature
# 


# Option: export Area (Max.) or Intensity (Max.) for each feature
ExportValue = "Area (Max.)"   # or use ExportValue = "Intensity (Max.)"

getTableIdx <- function(JSON_in, name) {
  TableNames <- sapply (JSON_in$Tables, function(x) x$TableName)
  which(TableNames %in% name)
}
  
getTable <- function(JSON_in, name) {
  
  TableNames <- sapply (JSON_in$Tables, function(x) x$TableName)
  idx <- TableNames %in% name
  
  if (!any(idx)) 
    stop("Table not found.")
  
  read.table(JSON_in$Tables[[ which(idx) ]]$DataFile, 
             header=TRUE, check.names = FALSE, stringsAsFactors = FALSE)
}

# Read arguments from CD.
args <- commandArgs()

# At least for now, the 6th argument is the name of the JSON file
inputFile <- args[6]

# Open JSON file, find exported files, read into tables
library(rjson)
CD_json_in <- fromJSON(file=inputFile)

Compounds <- getTable(CD_json_in, "Compounds")
Features <- getTable(CD_json_in, "Features")
Compounds_Features_ID <-  getTable(CD_json_in, "ConsolidatedUnknownCompoundItem-ConsolidatedUnknownCompoundIonItem")


# for debugging only 
if (cli:::hash_sha256(Sys.info()['nodename']) == "9305bdadbfc83a0d4715aba4a269da4c719821a8fb64782b46d110bc83a53a19" )  #do this only when running on Ralf's laptop
  save.image(file="C:\\TEMP\\CD node Rimage1.dat")
# load("C:\\TEMP\\CD node Rimage1.dat")

# order Compounds by max Area
Compounds <- Compounds[order(Compounds[,"Area (Max.)"],decreasing = TRUE),]

## prepare a list for output
resL <- vector("list", nrow(Compounds))
  
## loop through all Compounds
for (ci in 1:nrow(Compounds)) {
 
  cid <- Compounds[ci,"Compounds ID"]
  
  fid <- Compounds_Features_ID[ (Compounds_Features_ID[,'Compounds ID'] %in% cid), "Features ID"]
  
  #get the features for this sample and compound ID
  features <- Features[ Features[,'Features ID'] %in% fid  ,]
  
  #order by Intensity (Max.) or Area (Max.) decreasing 
  oidx <- order(features[,ExportValue],decreasing = TRUE) 

  
  #results for this compound
  resL[[ci]] <- cbind("Name"=Compounds[ci,"Name"],
                      "Formula"=Compounds[ci,"Formula"],
                      "Calc. MW"=Compounds[ci,"Calc. MW"],
                      "RT [min]"=Compounds[ci,"RT [min]"], 
                      features[oidx,c("Ion", "m/z", ExportValue)])
  
}  

data.output <- do.call("rbind", resL)

resultout = paste(CD_json_in$ResultFilePath,"Export_All_Ions.csv",sep=".")
write.csv(data.output, file = resultout, row.names = FALSE)



